#Created by George Bargoud

from courseName import getClassName
from os         import listdir, mkdir, environ, path
from shutil     import move, copy
from sys        import argv

def moveFiles(src, des):
    if (not path.isdir(des)):
        mkdir(des)
    if (not path.isdir(src)):
        return
    for filename in listdir(src):
        if ('.note' not in filename):
            continue
        time = float(filename.rpartition('.')[0])
        course = getClassName(time)
        if course not in listdir(des):
            mkdir(des+'/'+course)
        move(src+'/'+filename, des+'/'+course+'/'+filename)
        
def copyFiles(src,des):
    if (not path.isdir(des)):
        mkdir(des)
    if (not path.isdir(src)):
        return
    for filename in listdir(src):
        if ('.note' not in filename):
            continue
        time = float(filename.rpartition('.')[0])
        course = getClassName(time)
        if course not in listdir(des):
            mkdir(des+'/'+course)
        copy(src+'/'+filename, des+'/'+course+'/'+filename)

def help():
    print "usage: \n python moveFiles.py [-cm] /path/to/source [/path/to/destination]"
    print "-c copies the files, -m moves them. default path to destination is your home directory"   
    print ""
    
def cl(argv):
    src = 1
    des = 2
    if (len(argv) == 1):
        help()
    else:
        if (argv[1][0] == '-'):
            src += 1
            des += 1
            if (argv[1][1] == 'm'):
                if (len(argv) == 3):
                    moveFiles(argv[src], environ['HOME'])
                else:
                    moveFiles(argv[src],argv[des])
                return
        if (len(argv) == des):
            copyFiles(argv[src], environ['HOME'])
        else:
            copyFiles(argv[src],argv[des])
            
if __name__ == "__main__":
    cl(argv)